#include "FTPServerConn.h"
#include "tools.h"
#include <direct.h>
#include "freestyledash.h"
#include "contentlist.h"

static const Lookup_t CommandLookup[] = {
    "USER", USER, "PASS", PASS, "CWD",  CWD,  "PORT", PORT, 
    "QUIT", QUIT, "PASV", PASV, "ABOR", ABOR, "DELE", DELE,
    "RMD",  RMD,  "XRMD", XRMD, "MKD",  MKD,  "XMKD", XMKD,
    "PWD",  PWD,  "XPWD", XPWD, "LIST", LIST, "NLST", NLST,  
    "SYST", SYST, "TYPE", TYPE, "MODE", MODE, "RETR", RETR,
    "STOR", STOR, "REST", REST, "RNFR", RNFR, "RNTO", RNTO,
    "STAT", STAT, "NOOP", NOOP, "MDTM", MDTM, "SIZE", xSIZE,
	"EXEC", EXEC, "REBO", REBO, "CDUP", CDUP, "RAM", RAM
};

int addrlen = sizeof(struct sockaddr_in);

CFTPServerConn::CFTPServerConn(void)
{
}

CFTPServerConn::~CFTPServerConn(void)
{ 
}

void CFTPServerConn::SendReply(char * Reply)
{
    char ReplyStr[MAX_PATH+20];
    printf("    %s\n",Reply);
    sprintf_s(ReplyStr, MAX_PATH+20, "%s\r\n", Reply);
    send(CommandSocket, ReplyStr, strlen(ReplyStr),0);
}

unsigned long CFTPServerConn::Process(void* parameter)
{
	Drive = "Game:";

	Drives.push_back("Game");
	if (Mounted[DEVICE_USB0])
		Drives.push_back("Usb0");
	if (Mounted[DEVICE_USB1])
		Drives.push_back("Usb1");
	if (Mounted[DEVICE_USB2])
		Drives.push_back("Usb2");
	if (Mounted[DEVICE_HARDISK0_PART1])
		Drives.push_back("Hdd1");
	if (Mounted[DEVICE_HARDISK0_SYSPART])
		Drives.push_back("HddX");
	if (Mounted[DEVICE_MEMORY_UNIT0])
		Drives.push_back("Memunit0");
	if (Mounted[DEVICE_MEMORY_UNIT1])
		Drives.push_back("Memunit1");
	if (Mounted[DEVICE_MEMORY_ONBOARD])
		Drives.push_back("OnBoardMU");
	if (Mounted[DEVICE_NAND_FLASH])
		Drives.push_back("Flash");
	if (Mounted[DEVICE_CDROM0])
		Drives.push_back("Dvd");
//	if (Mounted[DEVICE_TEST])
//		Drives.push_back("Test");

	//Drives.push_back("dice");

    char buf[MAX_PATH+10];
    char repbuf[MAX_PATH+10];
    string NewPath;

	// Indicate ready to accept commands
    SendReply("220 Minftpd ready");

	//FTPMsg("Creating Passive Port %d", XferPort);
    PassiveSocket = CreateTcpipSocket(&XferPort);
 	//FTPMsg("Passive port created %d, %d", XferPort,PassiveSocket);

    if (PassiveSocket < 0){
        goto EndConnection;
    }

    if(listen(PassiveSocket, 1) == -1){
        FTPMsg("passive socket listen failed");
        goto EndConnection;
    }

    for(;;)
	{
        // Get FTP command from input stream
        CmdTypes FtpCommand;

        FtpCommand = GetCommand(buf);
		string dir = MyGetDir();
		MEMORYSTATUS stat;
		switch(FtpCommand){
            case USER:
                SendReply("331 pretend login accepted");
                break;

            case PASS:
                SendReply("230 fake user logged in");
                break;

            case SYST:
                SendReply("215 Freestyle FTPd");
                break;
			case RAM:
			
			

				
				 GlobalMemoryStatus( &stat );
				 
				 sprintf_s(repbuf,MAX_PATH+10, "250 (%4u total mb of ram free)",stat.dwAvailPhys/(1024*1024));
					 SendReply(repbuf);
					 // Setup the output string.
				// pstrOut = strOut;
  //  AddStr( "%4u free MB\n", stat.dwAvailPhys / MB );

	//wstring temp = strtowstr(strOut);
			//	SendReply("250 OK");
				break;
            case PASV:
                sprintf_s(repbuf,MAX_PATH+10, "227 Entering Passive Mode (%S,%d,%d)",xboxip.c_str(),
                    XferPort >>8, XferPort & 0xff);
                for (int a=0;a<50;a++){
                    if (repbuf[a] == 0) break;
                    if (repbuf[a] == '.') repbuf[a] = ',';
                }
                SendReply(repbuf);
                PassiveMode = true; 
                break;

            case XPWD:
            case PWD: // Print working directory
				sprintf_s(repbuf,MAX_PATH+10,"257 \"%s\"", MyGetDir().c_str());
				SendReply(repbuf);
                break;
			case CDUP:
			
				DebugMsg("From %s",dir.c_str());
				DebugMsg("Last char is %s",dir.substr(dir.size()-1,1).c_str());
				if(dir.substr(dir.size()-1,1) == "\\")
				{
					DebugMsg("End with slash",dir.c_str());
					dir = dir.substr(0,dir.size()-1);
				}
				
				dir = dir.substr(0,dir.rfind("\\")+1);
				DebugMsg(dir.c_str());
			//	sprintf_s(repbuf,MAX_PATH+10, "250 command successful(%S,%d,%S)",MyGetDir().c_str(),dir.rfind("\\",dir.size()),dir.c_str());
				if (!MySetDir(dir)){
                    SendReply("550 Could not change directory");
                }else{
                    SendReply("250 CDUP command successful");
                }
			
				break;
            case NLST: // Request directory, names only.
                //NewPath = TranslatePath(buf);
                /*if (NewPath == NULL){
                    SendReply(Conn, "550 Path permission error");
                    break;
                }*/
                Cmd_NLST(buf, false, FALSE);
                break;

            case LIST: // Request directory, long version.
                //NewPath = TranslatePath(buf);
                /*if (NewPath == NULL){
                    SendReply(Conn, "550 Path permission error");
                }*/
                Cmd_NLST(buf, false, FALSE);
                break;

            case STAT: // Just like LIST, but use control connection.
                //NewPath = TranslatePath(buf);
                /*if (NewPath == NULL){
                    SendReply(Conn, "550 Path permission error");
                    break;
                }*/
                Cmd_NLST(buf, false, TRUE);
                break;

            case DELE:
                NewPath = TranslatePath(buf);
                /*if (NewPath == NULL){
                    SendReply(Conn, "550 Path permission error");
                    break;
                }*/
				if (unlink(NewPath.c_str())){
                    Send550Error();
                }else{
                    SendReply("250 DELE command successful.");
                }
                break;

            case RMD:
            case MKD:
            case XMKD:
            case XRMD:
                /*if (GetOnly){
                    SendReply("550 Permission denied");
                    break;
                }*/
                NewPath = TranslatePath(buf);
                /*if (NewPath == NULL){
                    SendReply("550 Path permission error");
                    break;
                }*/
                if (FtpCommand == MKD || FtpCommand == XMKD){
					if (_mkdir(NewPath.c_str())){
                        Send550Error();
                    }else{
                        SendReply("257 Directory created");
                    }
                }else{
					if (_rmdir(NewPath.c_str())){
                        Send550Error();
                    }else{
                        SendReply("250 RMD command successful");
                    }
				}
                break;

            case RNFR:
                NewPath = TranslatePath(buf);
				if (!NewPath.empty()){
					strcpy_s(repbuf,MAX_PATH+10, NewPath.c_str());
                    SendReply("350 File Exists");
                }else{
                    SendReply("550 Path permission error");
                }
                break;
                
            case RNTO:
                // Must be immediately preceeded by RNFR!
                /*if (GetOnly){
                    SendReply("550 Permission denied");
                    break;
                }*/
                NewPath = TranslatePath(buf);
				if (rename(repbuf, NewPath.c_str())){
                    Send550Error();
                }else{
                    SendReply("250 RNTO command successful");
                }
                break;

            case ABOR:
                SendReply("226 Aborted");
                break;

            /*case xSIZE:
            case MDTM:
                NewPath = TranslatePath(buf);
				StatCmds(NewPath.c_str(), FtpCommand);
                break;*/

            case CWD: // Change working directory
                if (!MySetDir(buf)){
                    SendReply("550 Could not change directory");
                }else{
                    SendReply("250 CWD command successful");
                }
                break;
 
            case TYPE: // Accept file TYPE commands, but ignore.
                SendReply("200 Type set to I");
                break;

            case NOOP:
                SendReply("200 OK");
                break;

            case PORT: // Set the TCP/IP addres for trasnfers.
                {
                    int h1,h2,h3,h4,p1,p2;
                    char *a, *p;
                    sscanf_s(buf,"%d,%d,%d,%d,%d,%d",&h1,&h2,&h3,&h4,&p1,&p2);
                    a = (char *) &xfer_addr.sin_addr;
                    p = (char *) &xfer_addr.sin_port;
                    a[0] = (char)h1; a[1] = (char)h2; a[2] = (char)h3; a[3] = (char)h4;
                    p[0] = (char)p1; p[1] = (char)p2;
                }
                SendReply("200 PORT command successful");
                break;

            case RETR: // Retrieve File and send it
                NewPath = TranslatePath(buf);
                /*if (NewPath == NULL){
                    SendReply(Conn, "550 Path permission error");
                    break;
                }*/
				Cmd_RETR(NewPath.c_str());
                break;

            case STOR: // Store the file.
                /*if (GetOnly){
                    SendReply(Conn, "553 Permission denied");
                    break;
                }*/
                NewPath = TranslatePath(buf);
                /*if (NewPath == NULL){
                    SendReply(Conn, "550 Path permission error");
                    break;
                }*/
				Cmd_STOR(NewPath.c_str());
                break;

            case UNKNOWN_COMMAND:
                SendReply("500 command not recognized");
                break;

            case QUIT: 
                SendReply("221 goodbye");
                goto EndConnection;

			case EXEC:
                //NewPath = TranslatePath(buf);
				Cmd_EXEC(buf);
				break;

			case REBO:
				SendReply("221 goodbye");
				closesocket(CommandSocket);
				closesocket(PassiveSocket);
				RestartFreestyle();
				break;

            case -1:
                goto EndConnection;


            default: // Any command not implemented, return not recognized response.
                SendReply("500 command not implemented");
                break;
        }
	}

EndConnection:
    //FTPMsg("Closing control connection\n");
    closesocket(CommandSocket);
	closesocket(PassiveSocket);
    //PortsUsed[Conn->XferPort & 255] = 0;
    //free(Conn);
		
	return 0;
}

//------------------------------------------------------------------------------------
// Handle the NLST command (directory)
//------------------------------------------------------------------------------------
void CFTPServerConn::Cmd_NLST(string filename, bool Long, bool UseCtrlConn)
{
    char repbuf[500];
    int xfer_sock;

	//FTPMsg("Init Connection for LIST");
    if (UseCtrlConn){
        xfer_sock = CommandSocket;
    }else{
        SendReply("150 Opening connection");

        if (PassiveMode){
			//FTPMsg("Passive Accept");
            xfer_sock = accept(PassiveSocket, NULL, NULL);
 			//FTPMsg("Accepted");
       }else{
            // Create TCP/IP connection for data link
            xfer_sock = ConnectTcpip(&xfer_addr,addrlen);
            if(xfer_sock < 0) {
                Send550Error();
                return;
            }
        }
    }

	bool ListAll = false;

    //struct _finddata_t finddata;
    //long find_handle;

	//FTPMsg("Starting LIST %s",filename.c_str());

	//if (filename.empty()) filename = "\\*.*";
    if (filename.substr(0,1) == "-"){ 
		for (unsigned int a=1;a < filename.size();a++){
			if (filename.substr(a,1) == "a" || filename.substr(a,1) == "A") ListAll = true;
            if (filename.substr(a,1) == "l") Long = true;
        }
        filename = "";
    }

	ListAll = true;
	Long = true;

	//FTPMsg("Do TranslatePath %s",filename.c_str());
	//filename = Drive + DirNow + filename;
	filename = TranslatePath(filename);

	//FTPMsg("TranslatePath Done %s",filename.c_str());
	if (filename.size() < 3)
	{
		//FTPMsg("LISTING DRIVES");
		vector <string>::iterator itr;
		for (itr = Drives.begin() ; itr != Drives.end() ; itr++)
		{
			if (Long){
				sprintf_s(repbuf,500,"%cr%c-r%c-r%c-   1 root  root    %d %s %s\r\n", 
						'd', '-', '-', '-',
						0,
						"2009-01-01-10:10",
						(*itr).c_str());
			}else{
				sprintf_s(repbuf,500, "%s\r\n",(*itr).c_str());
			}
			//FTPMsg(repbuf);
			send(xfer_sock, repbuf, strlen(repbuf),0);
		}
	} else {
		//FTPMsg("LISTING FILES");
		filename.append("\\*.*");
		//FTPMsg("Final \"%s\"",filename.c_str());

		filename = str_replaceallA(filename,"\\\\","\\");
		WIN32_FIND_DATA findFileData;
		memset(&findFileData,0,sizeof(WIN32_FIND_DATA));
		//FTPMsg(searchcmd.c_str());
		HANDLE hFind = FindFirstFile(filename.c_str(), &findFileData);

		//FTPMsg("LIST %s",filename.c_str());

		if (hFind != INVALID_HANDLE_VALUE)
		{
			do {
				string s = findFileData.cFileName;

				if (s == ".") continue;
				if (s == "..") continue;

				if (Long){
					//struct tm tm;
					char DirAttr;
					char WriteAttr;

					// Call mktime to get weekday and such filled in.
					//tm = *localtime(&findFileData.ftLastWriteTime);
					//strftime(timestr, 20, "%b %d  %Y", &tm);
		            
					/*if (finddata.attrib & (_A_HIDDEN | _A_SYSTEM)){
						if (!ListAll) goto next_file;
					}*/

					DirAttr = findFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ? 'd' : '-';
					WriteAttr = findFileData.dwFileAttributes & FILE_ATTRIBUTE_READONLY ? '-' : 'w';

					sprintf_s(repbuf,500,"%cr%c-r%c-r%c-   1 root  root    %d %s %s\r\n", 
							DirAttr, WriteAttr, WriteAttr, WriteAttr,
							(unsigned)findFileData.nFileSizeLow,
							"Jan 20  2001",
							findFileData.cFileName); 
					//FTPMsg(repbuf);
				}else{
					sprintf_s(repbuf, 500, "%s\r\n",s.c_str());
				}
				send(xfer_sock, repbuf, strlen(repbuf),0);

			} while (FindNextFile(hFind, &findFileData));
			FindClose(hFind);
		} else {
			FTPMsg("Empty dir");
		}
	}

	if (!UseCtrlConn){
        closesocket(xfer_sock);
        SendReply("226 Transfer Complete");
    }
}


CmdTypes CFTPServerConn::GetCommand(char *CmdArg) 
{
    char InputString[500+1];
    int  CmdLen;
    char Command[6];
    int  a,b;

    // Read in command string
    CmdLen = 0;
    memset(InputString, 0, sizeof(InputString));
    for (;;){
        int n;
        n = recv(CommandSocket, InputString+CmdLen, sizeof(InputString)-CmdLen,0);
        CmdLen += n;
        if (strstr(InputString, "\r")) break;
        if (n <= 0) return INVALID_COMMAND;
    }

    memset(Command, 0, sizeof(Command));
    for(a=0;a<5;a++) {
        if (!isalpha(InputString[a])) break;
        Command[a] = (char)toupper(InputString[a]);
    }

    b = 0;
    if (InputString[a++] == ' '){
        for (b=0;b<500-1;b++){
            if (InputString[a+b] < 32) break;
            CmdArg[b] = InputString[a+b];
        }
    }
    CmdArg[b] = 0;

    FTPMsg("%s %s\n", Command, CmdArg);

    // Search through the list of known commands
    for(a=0;a<sizeof(CommandLookup)/sizeof(Lookup_t);a++){
        if(strncmp(Command, CommandLookup[a].command,4)==0){
            return CommandLookup[a].CmdNum;
        }
    }
    //FTPMsg("Unknown command '%s'\n",Command);
    return UNKNOWN_COMMAND;
}

string CFTPServerConn::MyGetDir(void)
{
	if (DirNow.empty())
		return "\\";
	return DirNow;
}





bool CFTPServerConn::MySetDir(string dir)
{

	string NewDirNow = DirNow;
	string transDir;

	if (dir == "..") 
	{
		int offset = NewDirNow.find_last_of("\\");
		transDir = NewDirNow.substr(0,offset+1);  // include the trailing backslash
		NewDirNow = NewDirNow.substr(0,offset);  

		if (transDir.length() <= 0)
			return false;

	/*	if (transDir.substr(transDir.length()-1,1) == "\\") {
			transDir.append("*");
		}*/

		transDir = TranslatePath(transDir);
		


	DebugMsg("Change to  %s");
	if(transDir.size() <3 ) 
		{
			DirNow = NewDirNow;
			return true;
		}
		else
		{
			DWORD gfa = GetFileAttributes(transDir.c_str());
			if(gfa!=0xffffffff)
			{
				DirNow = NewDirNow;
				return true;
			}
			return false;
		}
		
	}

	if (dir == "~") dir = "\\";

	dir = str_replaceallA(dir,"/","\\");

	if (dir.substr(0,1) == "\\")
	{
		NewDirNow = dir;
	} 
	else 
	{
		NewDirNow.append("\\");
		NewDirNow.append(dir);
	}
	NewDirNow = str_replaceallA(NewDirNow,"\\\\","\\");

	string transPath = NewDirNow;
		
	transPath = TranslatePath(transPath);

/*	if (transPath.substr(transPath.length()-1,1) == "\\") {
		transPath.append("*");
	}*/

	

	DebugMsg("Change to  %s",transPath.c_str());
	if(transPath.size() <3) 
	{
			DebugMsg("Apply");
		DirNow = NewDirNow;
		return true;
	}
	else
	{
		DWORD gfa = GetFileAttributes(transPath.c_str());
		DebugMsg("Attribs  %08x",gfa);
		if(gfa!=0xffffffff){
			DirNow = NewDirNow;
			return true;
		}
	
	}
	
	return false;
	
}

string CFTPServerConn::TranslatePath(string inpath)
{
	//FTPMsg("TranslatePath \"%s\"",inpath.c_str());
	// path passed in is empty
	if (inpath.empty())
	{
		if (DirNow.empty())
			return "";

		return TranslatePath(DirNow);
	}

	// inpath is \ so return it
	if (inpath == "\\")
		return inpath;

	// path passed in dont start with \ so relative to DirNow
	if (inpath.substr(0,1) != "\\")
	{		//FTPMsg("RELATIVE");
		string Drive = DirNow.substr(1);
		Drive = Drive.substr(0,Drive.find("\\"));
		//FTPMsg("Drive \"%s\"",Drive.c_str());

		string Dir = DirNow.substr(1);
		if (Dir.find("\\") != Dir.npos)
		{
			Dir = Dir.substr(Dir.find("\\"));
		} else {
			Dir = "";
		}
		//FTPMsg("Dir \"%s\"",Dir.c_str());
		inpath = Drive + ":\\" + Dir + "\\" + inpath;
		inpath = str_replaceallA(inpath,"\\\\","\\");
		//FTPMsg("Final \"%s\"",inpath.c_str());

		return inpath;
	// path passed in starts with a \ so its absolute,
	}


	//FTPMsg("ABSOLUTE");

	string Drive = inpath.substr(1);
	Drive = Drive.substr(0,Drive.find("\\"));
	//FTPMsg("Drive \"%s\"",Drive.c_str());

	string Dir = inpath.substr(1);
	if (Dir.find("\\") != Dir.npos)
	{
		Dir = Dir.substr(Dir.find("\\"));
	} else {
		Dir = "";
	}
	//FTPMsg("Dir \"%s\"",Dir.c_str());
	inpath = Drive + ":\\" + Dir;
	inpath = str_replaceallA(inpath,"\\\\","\\");
	//FTPMsg("Final \"%s\"",inpath.c_str());

	return inpath;
}

int CFTPServerConn::CreateTcpipSocket(int * Port)
{
	SOCKET server;

	sockaddr_in local;
	local.sin_family=AF_INET;
	local.sin_addr.s_addr=INADDR_ANY;
	local.sin_port=htons((u_short)*Port);

	server=socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);

	if(server==INVALID_SOCKET)
	{
		FTPMsg( "INVALID SOCKET!");
		return 0;
	}

	// after setting these undocumented flags on a socket they should then run unencrypted
	BOOL bBroadcast = TRUE;

	if( setsockopt(server, SOL_SOCKET, 0x5802, (PCSTR)&bBroadcast, sizeof(BOOL) ) != 0 )//PATCHED!
	{
		FTPMsg( "Failed to set socket to 5802, error");
		return 0;
	}

	if( setsockopt(server, SOL_SOCKET, 0x5801, (PCSTR)&bBroadcast, sizeof(BOOL) ) != 0 )//PATCHED!
	{
		FTPMsg( "Failed to set socket to 5801, error");
		return 0;
	}

	if ( bind( server, (const sockaddr*)&local, sizeof(local) ) == SOCKET_ERROR )
	{
		int Error = WSAGetLastError();
		FTPMsg("bind error %d",Error);
		return 0; 
	}

    // Get the assigned port number
	int size = sizeof(local);
    if (getsockname(server,(struct sockaddr *)&local,&size) < 0){
        FTPMsg("Error: getsockname() failed");
        return -1;
    }

    // Convert network byte order to host byte order
    *Port = ntohs(local.sin_port);

    return server;
}

int CFTPServerConn::ConnectTcpip(struct sockaddr_in *addr, int addrlen) 
{
    int sock;
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if(sock<0){
        FTPMsg("socket() failed");
        return -1;
    }

	// after setting these undocumented flags on a socket they should then run unencrypted
	BOOL bBroadcast = TRUE;

	if( setsockopt(sock, SOL_SOCKET, 0x5802, (PCSTR)&bBroadcast, sizeof(BOOL) ) != 0 )//PATCHED!
	{
		FTPMsg( "Failed to set socket to 5802, error");
		return 0;
	}

	if( setsockopt(sock, SOL_SOCKET, 0x5801, (PCSTR)&bBroadcast, sizeof(BOOL) ) != 0 )//PATCHED!
	{
		FTPMsg( "Failed to set socket to 5801, error");
		return 0;
	}

	if(connect(sock,(struct sockaddr *)addr, addrlen) < 0){
        FTPMsg("connect() failed");
        return -1;
    }
    return sock;
}

void CFTPServerConn::Send550Error()
{
    char ErrString[200];
#pragma warning(disable:4996)
    sprintf_s(ErrString, 200, "550 %s",sys_errlist[errno]);
#pragma warning(default:4996)
    SendReply(ErrString);
}

void CFTPServerConn::Cmd_RETR(const char *filename) 
{
    int xfer_sock;
    int size;

    // Check to see if the file can be opened for reading
	FILE * fp = NULL;
	fopen_s(&fp,filename,"rb");
    //if((file = open(filename, _O_RDONLY | _O_BINARY)) < 0) {
	if (!fp)
	{
        Send550Error();
        return;
    }

    // File opened succesfully, so make the connection
    SendReply("150 Opening BINARY mode data connection");

    if (PassiveMode){
        xfer_sock = accept(PassiveSocket, NULL, NULL);
    }else{
        // Create TCP/IP connection for data link
        xfer_sock = ConnectTcpip(&xfer_addr,addrlen);
        if(xfer_sock < 0) {
            Send550Error();
            return;
        }
    }

    // Transfer file
    for(size=1;size > 0;){
		size = fread(XferBuffer, 1, XFERSIZE, fp);
		//FTPMsg("Got size %d",size);
        //size = read(file, XferBuffer, sizeof(XferBuffer));

        if(size < 0) {
            break;
        }

		int tosend = size;
		int sent = 1;
		int offset = 0;
		while (tosend > 0)
		{
        // Write buffer to socket.
			sent = send(xfer_sock, XferBuffer+offset, tosend, 0);
			tosend -= sent;
			offset += sent;

			if (sent < 1)
			{
				FTPMsg("send failed");
				SendReply("426 Broken pipe") ;
				size = -1;
				tosend = 0;
			}
		}
    }
    

    if(size < 0){
        Send550Error();
    }else{
        SendReply("226 Transfer Complete");
    }

    closesocket(xfer_sock);
    fclose(fp);
}

void CFTPServerConn::Cmd_STOR(const char *filename) 
{
    FILE * file;
    int xfer_sock;
    int size;

    // Check to see if the file can be opened for reading
    file = NULL;
	fopen_s(&file,filename, "wb");
    if(file == NULL){
        Send550Error();
        return;
    }

    // File opened succesfully, so make the connection
    SendReply("150 Opening BINARY mode data connection");

    if (PassiveMode){
        xfer_sock = accept(PassiveSocket, NULL, NULL);
    }else{
        // Create TCP/IP connection for data link
        xfer_sock = ConnectTcpip(&xfer_addr,addrlen);
        if(xfer_sock < 0) {
            Send550Error();
            return;
        }
    }

	int Offset = 0;
	int Read = 0;

    // Transfer file
    for(size=1;size >= 0;){
        // Get from socket.
		while (size > 0 &&  Offset < XFERSIZE)
		{
			size = recv(xfer_sock, XferBuffer + Offset, XFERSIZE - Offset, 0);
			if(size < 0) {
				perror("read failed");
			}
			Read += size;
			Offset += size;
		}

        if (Read <= 0) break;

        // Write to file
       if (fwrite(XferBuffer, Read, 1, file) != 1){
            size=-1;
            break;
        }

		Read = 0;
		Offset = 0;
    }

    if(size < 0){
        Send550Error();
    }else{
        SendReply("226 Transfer Complete");
    }

    closesocket(xfer_sock);

    // For some reason, the file ends up readonly - should fix that.
    fclose(file);
}

void CFTPServerConn::Cmd_EXEC(const char *filename) 
{
	if (FileExistsA(filename))
	{
		SendReply("221 goodbye");
		closesocket(CommandSocket);
		closesocket(PassiveSocket);

		XLaunchNewImage(filename,0);
	} else {
		SendReply("550 File not found");
	}
}